/// \file pdfcjkfontdata.inc Definition of the default CJK fonts.

#include "wx/pdfcjkfontdata.h"

static short cwAllHw[] =
  {
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 500, 500, 500, 500, 500 
  };

static short cwBig5[] =
  {
    250, 250, 408, 668, 490, 875, 698, 250, 
    240, 240, 417, 667, 250, 313, 250, 520, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 250, 250, 667, 667, 667, 396, 
    921, 677, 615, 719, 760, 625, 552, 771, 
    802, 354, 354, 781, 604, 927, 750, 823, 
    563, 823, 729, 542, 698, 771, 729, 948, 
    771, 677, 635, 344, 520, 344, 469, 500, 
    250, 469, 521, 427, 521, 438, 271, 469, 
    531, 250, 250, 458, 240, 802, 531, 500, 
    521, 521, 365, 333, 292, 521, 458, 677, 
    479, 458, 427, 480, 496, 480, 667
  };

static short cwGb[] =
  {
    207, 270, 342, 467, 462, 797, 710, 239, 
    374, 374, 423, 605, 238, 375, 238, 334, 
    462, 462, 462, 462, 462, 462, 462, 462, 
    462, 462, 238, 238, 605, 605, 605, 344, 
    748, 684, 560, 695, 739, 563, 511, 729, 
    793, 318, 312, 666, 526, 896, 758, 772, 
    544, 772, 628, 465, 607, 753, 711, 972, 
    647, 620, 607, 374, 333, 374, 606, 500, 
    239, 417, 503, 427, 529, 415, 264, 444, 
    518, 241, 230, 495, 228, 793, 527, 524, 
    524, 504, 338, 336, 277, 517, 450, 652, 
    466, 452, 407, 370, 258, 370, 605
  };

static short cwSjis[] =
  {
    278, 299, 353, 614, 614, 721, 735, 216, 
    323, 323, 449, 529, 219, 306, 219, 453, 
    614, 614, 614, 614, 614, 614, 614, 614, 
    614, 614, 219, 219, 529, 529, 529, 486, 
    744, 646, 604, 617, 681, 567, 537, 647, 
    738, 320, 433, 637, 566, 904, 710, 716, 
    605, 716, 623, 517, 601, 690, 668, 990, 
    681, 634, 578, 316, 614, 316, 529, 500, 
    387, 509, 566, 478, 565, 503, 337, 549, 
    580, 275, 266, 544, 276, 854, 579, 550, 
    578, 566, 410, 444, 340, 575, 512, 760, 
    503, 529, 453, 326, 380, 326, 387
  };

static short cwUhc[] =
  {
     333, 416, 416, 833, 625, 916, 833,  250, 
     500, 500, 500, 833, 291, 833, 291,  375, 
     625, 625, 625, 625, 625, 625, 625,  625, 
     625, 625, 333, 333, 833, 833, 916,  500, 
    1000, 791, 708, 708, 750, 708, 666,  750, 
     791, 375, 500, 791, 666, 916, 791,  750, 
     666, 750, 708, 666, 791, 791, 750, 1000, 
     708, 708, 666, 500, 375, 500, 500,  500, 
     333, 541, 583, 541, 583, 583, 375,  583, 
     583, 291, 333, 583, 291, 875, 583,  583, 
     583, 583, 458, 541, 375, 583, 583,  833, 
     625, 625, 500, 583, 583, 583, 750
  };

static short cwPGothic[] =
  {
    305, 219, 500, 500, 500, 500, 594, 203, 
    305, 305, 500, 500, 203, 500, 203, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 203, 203, 500, 500, 500, 453, 
    668, 633, 637, 664, 648, 566, 551, 680, 
    641, 246, 543, 598, 539, 742, 641, 707, 
    617, 707, 625, 602, 590, 641, 633, 742, 
    602, 590, 566, 336, 504, 336, 414, 305, 
    414, 477, 496, 500, 496, 500, 305, 461, 
    500, 211, 219, 461, 211, 734, 500, 508, 
    496, 496, 348, 461, 352, 500, 477, 648, 
    461, 477, 457, 234, 234, 234, 414
  };

static short cwUIGothic[] =
  {
    305, 219, 500, 500, 500, 500, 594, 203, 
    305, 305, 500, 500, 203, 500, 203, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 203, 203, 500, 500, 500, 453, 
    668, 633, 637, 664, 648, 566, 551, 680, 
    641, 246, 543, 598, 539, 742, 641, 707, 
    617, 707, 625, 602, 590, 641, 633, 742, 
    602, 590, 566, 336, 504, 336, 414, 305, 
    414, 477, 496, 500, 496, 500, 305, 461, 
    500, 211, 219, 461, 211, 734, 500, 508, 
    496, 496, 348, 461, 352, 500, 477, 648, 
    461, 477, 457, 234, 234, 234, 414
  };

static short cwPMincho[] =
  {
    305, 305, 461, 500, 500, 500, 613, 305, 
    305, 305, 500, 500, 305, 500, 305, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 
    500, 500, 305, 305, 500, 500, 500, 500, 
    727, 664, 621, 699, 691, 598, 598, 711, 
    723, 289, 387, 668, 586, 801, 664, 766, 
    563, 766, 602, 504, 625, 691, 664, 871, 
    656, 625, 563, 332, 500, 332, 305, 305, 
    305, 453, 500, 465, 500, 473, 254, 473, 
    500, 242, 242, 492, 242, 703, 500, 500, 
    500, 500, 367, 414, 352, 500, 477, 602, 
    469, 477, 453, 242, 219, 242, 500
  };

static const wxPdfCjkFontDesc gs_cjkFontTable[] =
{
  { wxT("big5"),     wxT("MSungStd-Light-Acro"),                        wxT("cp-950"), wxT("CNS1"),   wxT("0"), wxT("ETenms-B5-H"),    cwBig5,     wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 }, 
  { wxT("big5-hw"),  wxT("MSungStd-Light-Acro--ETen-B5-H"),             wxT("cp-950"), wxT("CNS1"),   wxT("0"), wxT("ETen-B5-H"),      cwAllHw,    wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 },
  { wxT("gb"),       wxT("STSongStd-Light-Acro"),                       wxT("cp-936"), wxT("GB1"),    wxT("2"), wxT("GBKp-EUC-H"),     cwGb,       wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 },
  { wxT("gb-hw"),    wxT("STSongStd-Light-Acro--GBK-EUC-H"),            wxT("cp-936"), wxT("GB1"),    wxT("2"), wxT("GBK-EUC-H"),      cwAllHw,    wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 }, 
  { wxT("sjis"),     wxT("KozMinPro-Regular-Acro"),                     wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwSjis,     wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 60, 1000, 500, -120, 40 }, 
  { wxT("sjis-hw"),  wxT("KozMinPro-Regular-Acro--90ms-RKSJ-H"),        wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90ms-RKSJ-H"),    cwAllHw,    wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 60, 1000, 500, -120, 40 }, 
  { wxT("uhc"),      wxT("HYSMyeongJoStd-Medium-Acro"),                 wxT("cp-949"), wxT("Korea1"), wxT("1"), wxT("KSCms-UHC-H"),    cwUhc,      wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 }, 
  { wxT("uhc-hw"),   wxT("HYSMyeongJoStd-Medium-Acro--KSCms-UHC-HW-H"), wxT("cp-949"), wxT("Korea1"), wxT("1"), wxT("KSCms-UHC-HW-H"), cwAllHw,    wxT("[0 -200 1000 900]"),  800, -200,  800, 6, 0, 50, 1000, 616, -130, 40 }, 
#if 0
// These M$ fonts don't work cross platform.
// To make them available as Type0 fonts they should be registered via RegisterFontCJK.
  { wxT("gothic"),   wxT("MS-Gothic"),                                  wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwAllHw,    wxT("[0 0 1000 1000]"),   1000,    0, 1000, 6, 0, 10, 1000, 553,  -66, 74 }, 
  { wxT("pgothic"),  wxT("MS-PGothic"),                                 wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwPGothic,  wxT("[0 0 1000 1000]"),   1000,    0, 1000, 6, 0, 10, 1000, 553,  -66, 74 }, 
  { wxT("uigothic"), wxT("MS-UIGothic"),                                wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwUIGothic, wxT("[0 0 1000 1000]"),   1000,    0, 1000, 6, 0, 10, 1000, 553,  -66, 74 }, 
  { wxT("mincho"),   wxT("MS-Mincho"),                                  wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwAllHw,    wxT("[0 0 1000 1000]"),   1000,    0, 1000, 6, 0, 10, 1000, 450,  -94, 47 }, 
  { wxT("pmincho"),  wxT("MS-PMincho"),                                 wxT("cp-932"), wxT("Japan1"), wxT("2"), wxT("90msp-RKSJ-H"),   cwPMincho,  wxT("[0 0 1000 1000]"),   1000,    0, 1000, 6, 0, 10, 1000, 450,  -94, 47 }, 
#endif
// Last dummy entry
  { wxEmptyString,   wxEmptyString,                                     wxEmptyString, wxEmptyString, wxEmptyString, wxEmptyString,    NULL,       wxEmptyString,               0,    0,    0, 0, 0,  0,    0,   0,    0,  0 }
};
