# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class CookieCutter(PolyDataAlgorithm):
    r"""
    CookieCutter - cut PolyData defined on the 2D plane with one or
    more polygons
    
    Superclass: PolyDataAlgorithm
    
    This filter crops an input PolyData consisting of cells (i.e.,
    points, lines, polygons, and triangle strips) with trim loops
    specified by a second input containing polygons and/or polylines. The
    input PolyData and the loops must lie on the same plane. Note that
    this filter can handle concave polygons and/or loops. It may produce
    multiple output polygons for each polygon/loop interaction.
    Similarly, it may produce multiple line segments and so on. (The
    input to cookie cut (input0) is referred to as the input mesh, while
    the loops used to cut the input mesh (input1) are referred to as the
    trim loops.)
    
    The filter has the option to pass through and generate point and cell
    data.  If pass_cell_data is enabled, then the cell data associated with
    the cropped cells, or cells passed through from the input mesh, are
    passed through to the output. If pass_point_data is enabled, then in
    similar fashion the point data is passed through; however new points
    generated by intersection may have point data interpolated in one of
    two ways. First, the input mesh edges are interpolated at the new
    intersection points to generate point data, or the trim loop edges
    are interpolated at the new intersection points to generate point
    data. Note: for pass_point_data and point interpolation to function,
    the filter requires that the point data attributes (from the mesh and
    trim loop) are exactly the same. If they are not, then a set
    intersection operation is performed which uses the point data arrays
    common to both the mesh and trim loops.
    
    @warning
    The mesh and trim loops must lie on the same plane and the plane may
    be arbitrarily oriented. If not on the same plane, tolerancing issues
    can produce erratic results.
    
    @sa
    ImprintFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCookieCutter, obj, update, **traits)
    
    pass_cell_data = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether cell data from the input mesh is to be passed
        through to the output mesh. By default, pass_cell_data is enabled.
        """
    )

    def _pass_cell_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCellData,
                        self.pass_cell_data_)

    pass_point_data = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether point data from the input mesh are to be passed
        through and/or interpolated to the output mesh. By default,
        pass_point_data is enabled. Note: both the input mesh points and
        the trim loops, must have identical point data. Otherwise, a set
        operation will be performed to process just the point data arrays
        common to both the mesh point data and loops point data.
        """
    )

    def _pass_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPointData,
                        self.pass_point_data_)

    point_interpolation = tvtk_base.RevPrefixMap({'mesh_edges': 0, 'loop_edges': 1}, default_value='mesh_edges', desc=\
        r"""
        If pass_point_data is on, indicate how new point data is to
        generated at the intersection points between the input mesh edges
        and the trim edges (trim edges form the loops). By default,
        point_interpolation is set to USE_MESH_EDGES.
        """
    )

    def _point_interpolation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointInterpolation,
                        self.point_interpolation_)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        r"""
        
        """
    )

    def _get_loops_connection(self):
        return wrap_vtk(self._vtk_obj.GetLoopsConnection())
    def _set_loops_connection(self, arg):
        old_val = self._get_loops_connection()
        self._wrap_call(self._vtk_obj.SetLoopsConnection,
                        deref_vtk(arg))
        self.trait_property_changed('loops_connection', old_val, arg)
    loops_connection = traits.Property(_get_loops_connection, _set_loops_connection, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_loops(self):
        return wrap_vtk(self._vtk_obj.GetLoops())
    loops = traits.Property(_get_loops, desc=\
        r"""
        
        """
    )

    def create_default_locator(self):
        """
        create_default_locator(self) -> None
        C++: void create_default_locator()
        Create default locator. Used to create one when none is
        specified. The locator is used to merge coincident points.
        """
        ret = self._vtk_obj.CreateDefaultLocator()
        return ret
        

    def set_loops_data(self, *args):
        """
        set_loops_data(self, loops:DataObject) -> None
        C++: void set_loops_data(DataObject *loops)
        Specify the a second PolyData input which defines trim loops
        used to cut the input polygonal data. These loops must be
        manifold, i.e., do not self intersect. The loops are defined from
        the polygons and polylines defined in this second input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLoopsData, *my_args)
        return ret

    _updateable_traits_ = \
    (('pass_cell_data', 'GetPassCellData'), ('pass_point_data',
    'GetPassPointData'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('point_interpolation', 'GetPointInterpolation'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'pass_cell_data', 'pass_point_data', 'release_data_flag',
    'point_interpolation', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CookieCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pass_cell_data', 'pass_point_data'], ['point_interpolation'],
            ['object_name']),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CookieCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

