# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_window_interactor3d import RenderWindowInteractor3D


class VRRenderWindowInteractor(RenderWindowInteractor3D):
    r"""
    VRRenderWindowInteractor - Implements VR specific functions
    required by RenderWindowInteractor.
    
    Superclass: RenderWindowInteractor3D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRRenderWindowInteractor, obj, update, **traits)
    
    action_manifest_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _action_manifest_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetActionManifestFileName,
                        self.action_manifest_file_name)

    action_set_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _action_set_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetActionSetName,
                        self.action_set_name)

    physical_scale = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the physical scale (world / physical distance ratio)
        """
    )

    def _physical_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalScale,
                        self.physical_scale)

    def get_physical_translation(self, *args):
        """
        get_physical_translation(self, __a:Camera) -> Pointer
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPhysicalTranslation, *my_args)
        return ret

    def set_physical_translation(self, *args):
        """
        set_physical_translation(self, __a:Camera, __b:float, __c:float,
            __d:float) -> None
        C++: void set_physical_translation(Camera *, double, double,
            double) override;
        Set/get position of the physical coordinate system origin in
        world coordinates.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPhysicalTranslation, *my_args)
        return ret

    physical_view_direction = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get the direction of the physical coordinate system -Z axis
        in world coordinates.
        """
    )

    def _physical_view_direction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalViewDirection,
                        self.physical_view_direction)

    physical_view_up = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/get the direction of the physical coordinate system +Y axis
        in world coordinates.
        """
    )

    def _physical_view_up_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalViewUp,
                        self.physical_view_up)

    def _get_pointer_device(self):
        return wrap_vtk(self._vtk_obj.GetPointerDevice())
    pointer_device = traits.Property(_get_pointer_device, desc=\
        r"""
        
        """
    )

    def get_starting_physical_to_world_matrix(self, *args):
        """
        get_starting_physical_to_world_matrix(self,
            startingPhysicalToWorldMatrix:Matrix4x4) -> None
        C++: void get_starting_physical_to_world_matrix(
            Matrix4x4 *startingPhysicalToWorldMatrix)"""
        ret = self._wrap_call(self._vtk_obj.GetStartingPhysicalToWorldMatrix, *args)
        return ret

    def convert_pose_to_world_coordinates(self, *args):
        """
        convert_pose_to_world_coordinates(self,
            poseInTrackingCoordinates:Matrix4x4, pos:[float, float,
            float], wxyz:[float, float, float, float], ppos:[float, float,
             float], wdir:[float, float, float]) -> None
        C++: void convert_pose_to_world_coordinates(
            Matrix4x4 *poseInTrackingCoordinates, double pos[3],
            double wxyz[4], double ppos[3], double wdir[3])"""
        ret = self._wrap_call(self._vtk_obj.ConvertPoseToWorldCoordinates, *args)
        return ret

    def do_one_event(self, *args):
        """
        do_one_event(self, renWin:VRRenderWindow, ren:Renderer)
            -> None
        C++: virtual void do_one_event(VRRenderWindow *renWin,
            Renderer *ren)
        Implements the event loop.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DoOneEvent, *my_args)
        return ret

    def set_class_exit_method(self, *args):
        """
        set_class_exit_method(f:Callback) -> None
        C++: static void set_class_exit_method(void (*f)(void *), void *arg)
        Methods to set the default exit method for the class. These
        methods are only used if no instance level exit_method has been
        defined. They are provided as a means to control how an
        interactor is exited given the various language bindings (Win32,
        etc.).
        """
        ret = self._wrap_call(self._vtk_obj.SetClassExitMethod, *args)
        return ret

    _updateable_traits_ = \
    (('enable_render', 'GetEnableRender'), ('light_follow_camera',
    'GetLightFollowCamera'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('action_manifest_file_name', 'GetActionManifestFileName'),
    ('action_set_name', 'GetActionSetName'), ('physical_scale',
    'GetPhysicalScale'), ('physical_translation',
    'GetPhysicalTranslation'), ('physical_view_direction',
    'GetPhysicalViewDirection'), ('physical_view_up',
    'GetPhysicalViewUp'), ('translation3d', 'GetTranslation3D'),
    ('alt_key', 'GetAltKey'), ('control_key', 'GetControlKey'),
    ('desired_update_rate', 'GetDesiredUpdateRate'), ('dolly',
    'GetDolly'), ('done', 'GetDone'), ('event_position',
    'GetEventPosition'), ('event_size', 'GetEventSize'), ('key_code',
    'GetKeyCode'), ('key_sym', 'GetKeySym'), ('last_event_position',
    'GetLastEventPosition'), ('number_of_fly_frames',
    'GetNumberOfFlyFrames'), ('pointer_index', 'GetPointerIndex'),
    ('recognize_gestures', 'GetRecognizeGestures'), ('repeat_count',
    'GetRepeatCount'), ('rotation', 'GetRotation'), ('scale', 'GetScale'),
    ('shift_key', 'GetShiftKey'), ('size', 'GetSize'),
    ('still_update_rate', 'GetStillUpdateRate'), ('timer_duration',
    'GetTimerDuration'), ('timer_event_duration',
    'GetTimerEventDuration'), ('timer_event_id', 'GetTimerEventId'),
    ('timer_event_platform_id', 'GetTimerEventPlatformId'),
    ('timer_event_type', 'GetTimerEventType'), ('translation',
    'GetTranslation'), ('use_t_dx', 'GetUseTDx'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enable_render', 'global_warning_display',
    'light_follow_camera', 'action_manifest_file_name', 'action_set_name',
    'alt_key', 'control_key', 'desired_update_rate', 'dolly', 'done',
    'event_position', 'event_size', 'key_code', 'key_sym',
    'last_event_position', 'number_of_fly_frames', 'object_name',
    'physical_scale', 'physical_translation', 'physical_view_direction',
    'physical_view_up', 'pointer_index', 'recognize_gestures',
    'repeat_count', 'rotation', 'scale', 'shift_key', 'size',
    'still_update_rate', 'timer_duration', 'timer_event_duration',
    'timer_event_id', 'timer_event_platform_id', 'timer_event_type',
    'translation', 'translation3d', 'use_t_dx'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRRenderWindowInteractor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRRenderWindowInteractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enable_render', 'light_follow_camera'], [],
            ['action_manifest_file_name', 'action_set_name', 'alt_key',
            'control_key', 'desired_update_rate', 'dolly', 'done',
            'event_position', 'event_size', 'key_code', 'key_sym',
            'last_event_position', 'number_of_fly_frames', 'object_name',
            'physical_scale', 'physical_translation', 'physical_view_direction',
            'physical_view_up', 'pointer_index', 'recognize_gestures',
            'repeat_count', 'rotation', 'scale', 'shift_key', 'size',
            'still_update_rate', 'timer_duration', 'timer_event_duration',
            'timer_event_id', 'timer_event_platform_id', 'timer_event_type',
            'translation', 'translation3d', 'use_t_dx']),
            title='Edit VRRenderWindowInteractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRRenderWindowInteractor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

