/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class TryIterator<T>
implements Iterator<T> {
    private State state = State.PENDING;
    private T next;

    protected abstract T tryNext();

    protected final T done() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException();
        }
        switch (this.state) {
            case DONE: {
                return false;
            }
            case GOT_NEXT: {
                return true;
            }
        }
        this.state = State.FAILED;
        this.next = this.tryNext();
        if (this.state != State.DONE) {
            this.state = State.GOT_NEXT;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.PENDING;
        return this.next;
    }

    public final T current() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Not allowed.");
    }

    static enum State {
        PENDING,
        GOT_NEXT,
        DONE,
        FAILED;

    }
}

