#ifndef _NEXP_PBUILD_H
#define _NEXP_PBUILD_H

/* 
   Network Expect interface to libpbuild

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pbuild.h"

/*
 * PDU Control Block (PCB) structure
 */
struct _pcb {
    struct nexp_speaker *speaker;   /* speaker to use to send this PDU */
    const char *def;		    /* the PDU definition */
    struct timeval delay;	    /* sending delay between PDUs */
    int repeat_count;		    /* number of times to send this PDU */
    int keep_after_send;	    /* destroy the PDU after sending it? */
    const GNode *pdu;		    /* the PDU */
};

typedef struct _pcb pcb_t;

extern void nexp_pdu_output(pcb_t *, unsigned char *, size_t);
extern void pcb_dump(pcb_t *, int);
extern void pcb_destroy(pcb_t *);

#endif /* _NEXP_PBUILD_H */
