/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_USER_PROFILE_HPP
#define yf_USER_PROFILE_HPP

#include <vector>

#include <QString>
#include <QStringList>

#include "Layout.hpp"

using std::vector;

struct ExerciseResult
{
	size_t symbolCount;
	size_t millisecsSpent;
	QString worseTriLetter;
	QStringList mistakes;
	size_t rhythmPercent;
	time_t timestamp;

	QString toString() const;
	static ExerciseResult fromString(const QString& dump);
};

class UserProfile
{
 public:
	UserProfile(const QString& profilePath);

	QString getPath() const;

	const Layout& getLayout() const;
	QString getLayoutString() const;

	QString getFortuneArgumentsLine() const;
	const vector<ExerciseResult>& exercises() const;
	QString getGeneralStats() const;

	size_t getTotalSecondCount() const;
	size_t getTotalSymbolCount() const;
	size_t getTotalMistakeCount() const;

	void exerciseDone(const ExerciseResult& exerciseResult);

	enum ConstructNewProfileResult { Ok, ProfileExists, CombinationError, OtherError};
	static enum ConstructNewProfileResult constructNewProfile(const QString& newProfileName, const QString& layout);
	static bool isCorrectProfile(const QString& profilePath);
 private:
	vector<ExerciseResult> exerciseResults;
	Layout layout;
	QString layoutString; // "ru", "en", "en-dvorak" etc...

	const QString path;
};

#endif

