##############################################################################
#
#  Openfire 'AuthCheck' Filter Security Bypass Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/11
#
#  Revision: 1.1
#
#  Log: sghosal
#  Issue #0466 
#
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program. 
##############################################################################

if(description)
{
  script_id(900401);
  script_cve_id("CVE-2008-6508");
 script_bugtraq_id(32189);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_tag(name:"cvss_base", value:"7.9");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_name("Openfire 'AuthCheck Filter' Security Bypass Vulnerability");
  script_summary("Check for vulnerable version of Openfire");
  desc = "
  Overview: 
  The host is running Openfire and is prone to security bypass vulnerability.

  Vulnerability Insight:
  This vulnerability is caused due to error in the 'AuthCheck' filter while 
  imposing access restrictions via a specially crafted URL using 'setup/setup-'
  and followed by the directory traveral sequences. These can be exploited to
  cause underlying database, access or modify data.

  Impact:
  Successful exploitation will cause execution of arbitrary code.

  Impact Level: Network

  Affected Software/OS:
  Ignite Realtime Openfire version prior to 3.6.1.

  Fix: Upgrade to 3.6.1
  http://www.igniterealtime.org/downloads/index.jsp

  References:
  http://secunia.com/advisories/32478/
  http://www.igniterealtime.org/downloads/index.jsp
  http://www.andreas-kurtz.de/advisories/AKADV2008-001-v1.0.txt

  CVSS Score:
    CVSS Base Score     : 7.9 (AV:N/AC:M/Au:SI/C:C/I:C/A:N)
    CVSS Temporal Score : 6.2
  Risk factor: High";

  script_description(desc);
  script_dependencies("http_version.nasl");
  exit(0);
}


include("http_func.inc");

port = 9090;

if(get_port_state(port))
{
  request = http_get(item:"/login.jsp", port:port);
  response = http_send_recv(port:port, data:request);
  if(response == NULL){
    exit(0);
  }
  if("Openfire Admin Console" >< response)
  {
    pattern = "Version: ([0-2]\..*|3\.[0-5](\..*)?|3\.6(\.0)?)($|[^.0-9])";
    if(egrep(pattern:pattern, string:response)){
      security_warning(port);
    }
  }
}
