/*
 * window_main_tool.cc
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main_tool.h"


/*** Section : Tool ***********************************************************/

// Constructor
cSection_Tool::cSection_Tool( Gtk::Window& ref_window )
:
mHBox_SourceFile( false , Pdfchain::SPACING ),	// homogenous , spacing
mHBox_UpdateInfo( false , Pdfchain::SPACING ),
mHBox_FillForm(   false , Pdfchain::SPACING ),

mTable_Tool( 15 , 4 , false ),	// y_rows , x_columns , homogenous )

mFCButton_SourceFile(   ref_window , _("Tools - Select source PDF file ...") ),	// parent_window , title
mFCButton_DumpDataFile( ref_window , _("Tools - Select dump data file ...")  ),
mFCButton_FdfFile(      ref_window , _("Tools - Select FDF file ...")        ),

mFCDialog_SelectFolder( ref_window , _("Tools - Select output folder ...")     ),	// parent_window , title
mFCDialog_SaveAs_Pdf(   ref_window , _("Tools - Save output PDF file as ...")  ),
mFCDialog_SaveAs_Fdf(   ref_window , _("Tools - Save output FDF file as ...")  ),
mFCDialog_SaveAs_Dump(  ref_window , _("Tools - Save output dump file as ...") ),

mLabel_SourceFile(   _("Source file:")    , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),	// label , xalign , yalign , mnemonic
mLabel_DumpDataFile( _("Dump data file:") , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),
mLabel_FdfFile(      _("FDF file:")       , Gtk::ALIGN_END , Gtk::ALIGN_CENTER , false ),

mCButton_DumpDataFields_Utf8( _("UTF-8")    , false ),	// label , mnemonic
mCButton_DumpData_Utf8(       _("UTF-8")    , false ),
mCButton_UpdateInfo_Utf8(     _("UTF-8")    , false ),
mCButton_FillForm_DropXfa(    _("Drop XFA") , false ),
mCButton_FillForm_Flatten(    _("Flatten")  , false ),

mRBGroup_Tool( mRButton_UnpackFiles.get_group() ),

mRButton_UnpackFiles(    mRBGroup_Tool , _("Un_pack attached files from PDF file") , true ),	// group , label , mnemonic
mRButton_Compress(       mRBGroup_Tool , _("C_ompress PDF file")                   , true ),
mRButton_Uncompress(     mRBGroup_Tool , _("_Uncompress PDF file")                 , true ),
mRButton_DumpDataFields( mRBGroup_Tool , _("Dump data _fields from PDF file")      , true ),
mRButton_DumpData(       mRBGroup_Tool , _("_Dump data from PDF file")             , true ),
mRButton_UpdateInfo(     mRBGroup_Tool , _("Update _info of PDF file")             , true ),
mRButton_GenerateFdf(    mRBGroup_Tool , _("_Generate FDF from PDF file")          , true ),
mRButton_FillForm(       mRBGroup_Tool , _("Fill fo_rm at PDF file")               , true ),
mRButton_Flatten(        mRBGroup_Tool , _("A PDF file f_latten")                  , true ),
mRButton_DropXfa(        mRBGroup_Tool , _("Drop _XFA from PDF file")              , true ),

mHSeparator_A( Gtk::ORIENTATION_HORIZONTAL ),	// orientation
mHSeparator_B( Gtk::ORIENTATION_HORIZONTAL ),
mHSeparator_C( Gtk::ORIENTATION_HORIZONTAL ),

mVSeparator_FillForm( Gtk::ORIENTATION_VERTICAL ),

rSGroup_FCButton( Gtk::SizeGroup::create( Gtk::SIZE_GROUP_HORIZONTAL ) )
{
	rSGroup_FCButton->add_widget( mLabel_DumpDataFile );
	rSGroup_FCButton->add_widget( mLabel_FdfFile );

	mFCButton_SourceFile.set_halign(   Gtk::ALIGN_START );
	mFCButton_DumpDataFile.set_halign( Gtk::ALIGN_START );
	mFCButton_FdfFile.set_halign(      Gtk::ALIGN_START );
	
	mAlign_HSeparatorA.set_padding( Pdfchain::BORDER , Pdfchain::BORDER , 0 , 0 );	// top , bottom , left , right
	mAlign_HSeparatorB.set_padding( Pdfchain::BORDER , Pdfchain::BORDER , 0 , 0 );
	mAlign_HSeparatorC.set_padding( Pdfchain::BORDER , Pdfchain::BORDER , 0 , 0 );

	mAlign_HSeparatorA.add( mHSeparator_A );
	mAlign_HSeparatorB.add( mHSeparator_B );
	mAlign_HSeparatorC.add( mHSeparator_C );

	mHBox_SourceFile.set_border_width( Pdfchain::BORDER );
	mHBox_SourceFile.pack_start( mLabel_SourceFile      , false , false , 0 );	// widget , expand , fill , padding
	mHBox_SourceFile.pack_start( mFCButton_SourceFile   , true  , true  , 0 );

	mHBox_UpdateInfo.pack_start( mLabel_DumpDataFile    , false , false , 0 );
	mHBox_UpdateInfo.pack_start( mFCButton_DumpDataFile , true  , true  , 0 );

	mHBox_FillForm.pack_start( mLabel_FdfFile           , false , false , 0 );
	mHBox_FillForm.pack_start( mFCButton_FdfFile        , true  , true  , 0 );
	
	mTable_Tool.set_border_width( Pdfchain::BORDER );
	mTable_Tool.set_col_spacings( Pdfchain::SPACING );
	mTable_Tool.attach( mRButton_UnpackFiles         , 0 , 4 ,  0 ,  1 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Unpack files
	mTable_Tool.attach( mAlign_HSeparatorA           , 0 , 4 ,  1 ,  2 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , 0 , 0 );
	mTable_Tool.attach( mRButton_Compress            , 0 , 4 ,  2 ,  3 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Compress
	mTable_Tool.attach( mRButton_Uncompress	         , 0 , 4 ,  3 ,  4 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Uncompress
	mTable_Tool.attach( mAlign_HSeparatorB           , 0 , 4 ,  4 ,  5 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , 0 , 0 );
	mTable_Tool.attach( mRButton_DumpDataFields      , 0 , 3 ,  5 ,  6 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Dump data fields
	mTable_Tool.attach( mCButton_DumpDataFields_Utf8 , 3 , 4 ,  5 ,  6 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mRButton_DumpData            , 0 , 3 ,  6 ,  7 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Dump data
	mTable_Tool.attach( mCButton_DumpData_Utf8       , 3 , 4 ,  6 ,  7 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mRButton_UpdateInfo          , 0 , 3 ,  7 ,  8 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Update info
	mTable_Tool.attach( mCButton_UpdateInfo_Utf8     , 3 , 4 ,  7 ,  8 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mHBox_UpdateInfo             , 0 , 4 ,  8 ,  9 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	
	mTable_Tool.attach( mAlign_HSeparatorC           , 0 , 4 ,  9 , 10 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::EXPAND , 0 , 0 );
	mTable_Tool.attach( mRButton_GenerateFdf         , 0 , 4 , 10 , 11 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Generate FDF
	mTable_Tool.attach( mRButton_FillForm            , 0 , 1 , 11 , 12 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Fill form
	mTable_Tool.attach( mCButton_FillForm_DropXfa    , 1 , 2 , 11 , 12 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mVSeparator_FillForm         , 2 , 3 , 11 , 12 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mCButton_FillForm_Flatten    , 3 , 4 , 11 , 12 , Gtk::FILL | Gtk::SHRINK , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mHBox_FillForm               , 0 , 4 , 12 , 13 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );
	mTable_Tool.attach( mRButton_Flatten             , 0 , 4 , 13 , 14 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Flatten
	mTable_Tool.attach( mRButton_DropXfa             , 0 , 4 , 14 , 15 , Gtk::FILL | Gtk::EXPAND , Gtk::FILL | Gtk::SHRINK , 0 , 0 );	// Drop XFA

	mSWindow_Tool.add( mTable_Tool );

	pack_start( mHBox_SourceFile , false , false , 0 );	// widget , expand , fill , padding
	pack_start( mSWindow_Tool    , true  , true  , 0 );

	mRButton_DumpDataFields.signal_toggled().connect( sigc::mem_fun(
		*this , &cSection_Tool::onRButton_DumpDataFields_toggled ) );
		
	mRButton_DumpData.signal_toggled().connect( sigc::mem_fun(
		*this , &cSection_Tool::onRButton_DumpData_toggled ) );
		
	mRButton_UpdateInfo.signal_toggled().connect( sigc::mem_fun(
		*this , &cSection_Tool::onRButton_UpdateInfo_toggled ) );
		
	mRButton_FillForm.signal_toggled().connect( sigc::mem_fun(
		*this , &cSection_Tool::onRButton_FillForm_toggled ) );

	init();
}

// Destructor
cSection_Tool::~cSection_Tool()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cSection_Tool::~cSection_Tool()";	//TEST
#endif
}


// Method (public) : clear
void
cSection_Tool::clear()
{
	mFCButton_SourceFile.unselect_all();
	mFCButton_DumpDataFile.unselect_all();
	mFCButton_FdfFile.unselect_all();

	init();
	return;
}


// Method (public) : create command
std::string
cSection_Tool::createCommand()
{
	std::string str_command		= "";
	std::string str_sourcefile	= "";
	std::string str_dumpfile	= "";
	std::string str_fdffile		= "";
	std::string str_output		= "";

	if ( "" != ( str_sourcefile = mFCButton_SourceFile.get_filename() ) ) {

		if ( mRButton_UnpackFiles.get_active() ) {
			switch ( mFCDialog_SelectFolder.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SelectFolder.hide();
					str_output = mFCDialog_SelectFolder.get_current_folder();
					break;
				default:
					mFCDialog_SelectFolder.hide();
					break;
			}
		}
		else if ( mRButton_DumpDataFields.get_active() || mRButton_DumpData.get_active() ) {
			switch ( mFCDialog_SaveAs_Dump.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SaveAs_Dump.hide();
					str_output = mFCDialog_SaveAs_Dump.get_filename();
				default:
					mFCDialog_SaveAs_Dump.hide();
					break;
			}
		}
		else if ( mRButton_GenerateFdf.get_active() ) {
			switch ( mFCDialog_SaveAs_Fdf.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SaveAs_Fdf.hide();
					str_output = mFCDialog_SaveAs_Fdf.get_filename();
				default:
					mFCDialog_SaveAs_Fdf.hide();
					break;
			}
		}
		else if ( mRButton_UpdateInfo.get_active() ) {
			if ( "" != ( str_dumpfile = mFCButton_DumpDataFile.get_filename() ) ) {
				switch ( mFCDialog_SaveAs_Pdf.run() ) {
					case Gtk::RESPONSE_OK:
						mFCDialog_SaveAs_Pdf.hide();
						str_output = mFCDialog_SaveAs_Pdf.get_filename();
					default:
						mFCDialog_SaveAs_Pdf.hide();
						break;
				}
			}
		}
		else if ( mRButton_FillForm.get_active() ) {
			if ( "" != ( str_fdffile = mFCButton_FdfFile.get_filename() ) ) {
				switch ( mFCDialog_SaveAs_Pdf.run() ) {
					case Gtk::RESPONSE_OK:
						mFCDialog_SaveAs_Pdf.hide();
						str_output = mFCDialog_SaveAs_Pdf.get_filename();
					default:
						mFCDialog_SaveAs_Pdf.hide();
						break;
				}
			}
		}
		else {
			switch ( mFCDialog_SaveAs_Pdf.run() ) {
				case Gtk::RESPONSE_OK:
					mFCDialog_SaveAs_Pdf.hide();
					str_output = mFCDialog_SaveAs_Pdf.get_filename();
				default:
					mFCDialog_SaveAs_Pdf.hide();
					break;
			}
		}

		if ( "" != str_output ) {
		
			if ( mRButton_UnpackFiles.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::UNPACK_FILES;
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
			}
			else if ( mRButton_Compress.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
				str_command += " " + Pdfchain::Cmd::COMPRESS;
			}
			else if ( mRButton_Uncompress.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
				str_command += " " + Pdfchain::Cmd::UNCOMPRESS;
			}
			else if ( mRButton_DumpDataFields.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );

				switch ( mCButton_DumpDataFields_Utf8.get_active() ) {
					case true:	str_command += " " + Pdfchain::Cmd::DUMP_DATA_FIELDS_UTF8;	break;
					default:	str_command += " " + Pdfchain::Cmd::DUMP_DATA_FIELDS;		break;
				}
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
			}
			else if ( mRButton_DumpData.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				
				switch ( mCButton_DumpData_Utf8.get_active() ) {
					case true:	str_command += " " + Pdfchain::Cmd::DUMP_DATA_UTF8;	break;
					default:	str_command += " " + Pdfchain::Cmd::DUMP_DATA;		break;
				}
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
			}
			else if ( mRButton_UpdateInfo.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );

				switch ( mCButton_UpdateInfo_Utf8.get_active() ) {
					case true:	str_command += " " + Pdfchain::Cmd::UPDATE_INFO_UTF8;	break;
					default:	str_command += " " + Pdfchain::Cmd::UPDATE_INFO;		break;
				}
				str_command += " " + Pdfchain::quote_path( str_dumpfile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
			}
			else if ( mRButton_GenerateFdf.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::GENERATE_FDF;
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
			}
			else if ( mRButton_FillForm.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::FILL_FORM;
				str_command += " " + Pdfchain::quote_path( str_fdffile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );

				if ( mCButton_FillForm_DropXfa.get_active() ) 
					str_command += " " + Pdfchain::Cmd::DROP_XFA;

				if ( mCButton_FillForm_Flatten.get_active() ) 
					str_command += " " + Pdfchain::Cmd::FLATTEN;
			}
			else if ( mRButton_Flatten.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
				str_command += " " + Pdfchain::Cmd::FLATTEN;
			}
			else if ( mRButton_DropXfa.get_active() ) {
				str_command  = " " + Pdfchain::quote_path( str_sourcefile );
				str_command += " " + Pdfchain::Cmd::OUTPUT;
				str_command += " " + Pdfchain::quote_path( str_output );
				str_command += " " + Pdfchain::Cmd::DROP_XFA;
			}
		}
	}
	
	return str_command;
}


// Method (protected) : init
void
cSection_Tool::init()
{
	mRButton_UnpackFiles.set_active( true );

	mCButton_DumpDataFields_Utf8.set_active( true );
	mCButton_DumpData_Utf8.set_active( true );
	mCButton_UpdateInfo_Utf8.set_active( true );
	mCButton_FillForm_DropXfa.set_active( true );
	mCButton_FillForm_Flatten.set_active( false );

	mLabel_DumpDataFile.set_sensitive( false );
	mFCButton_DumpDataFile.set_sensitive( false );
	mLabel_FdfFile.set_sensitive( false );
	mFCButton_FdfFile.set_sensitive( false );
	mVSeparator_FillForm.set_sensitive( false );
	mCButton_DumpDataFields_Utf8.set_sensitive( false );
	mCButton_DumpData_Utf8.set_sensitive( false );
	mCButton_UpdateInfo_Utf8.set_sensitive( false );
	mCButton_FillForm_DropXfa.set_sensitive( false );
	mCButton_FillForm_Flatten.set_sensitive( false );

	return;
}
