/*
# PostgreSQL Database Modeler (pgModeler)
#
# (c) Copyright 2006-2026 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# DEVELOPMENT, MAINTENANCE AND COMMERCIAL DISTRIBUTION BY:
# Nullptr Labs Software e Tecnologia LTDA <contact@nullptrlabs.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also, you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

/**
\ingroup libgui
\class SQLExecutionHelper
\brief Implements a command execution helper that permit the execution of SQL commands in a thread
*/

#ifndef SQL_EXECUTION_HELPER_H
#define SQL_EXECUTION_HELPER_H

#include <QObject>
#include <QTableWidget>
#include "connection.h"
#include "utils/resultsetmodel.h"

class __libgui SQLExecutionHelper : public QObject {
	Q_OBJECT

	private:
		Connection connection;

		QString command;

		ResultSetModel *result_model;

		bool cancelled;

		int affected_rows;

		QStringList notices;

	public:
		SQLExecutionHelper();

		void setConnection(Connection conn);

		void setCommand(const QString &cmd);

		QString getCommand();

		//! \brief Returns the result set model created in the execution. This object is not deleted after the execution.
		ResultSetModel *getResultSetModel();

		bool isCancelled();

		//! \brief Returns the notices generated by the execution
		QStringList getNotices();

	public slots:
		void executeCommand();
		void cancelCommand();

	signals:
		void s_executionFinished(int rows_affected);
		void s_executionAborted(Exception e);
};

#endif
