# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxImagePreview;
use strict;
use base qw/Wx::Dialog Class::Accessor::Fast/;
use Wx qw/
             wxDefaultPosition
             wxDefaultSize
             wxBG_STYLE_CUSTOM
             wxIMAGE_QUALITY_HIGH
             wxRESIZE_BORDER
             wxDIALOG_EX_METAL
             wxDIALOG_NO_PARENT
             wxDEFAULT_DIALOG_STYLE
             wxMAXIMIZE_BOX
             wxMINIMIZE_BOX
             wxSTAY_ON_TOP
         /;

__PACKAGE__->mk_accessors( 
    qw/
          image
          image_size
          caption
      / 
);
use Data::Dumper;
use Wx::Event qw/
   EVT_PAINT
   EVT_SIZE
/;

sub new {
    my( $class, $params ) = @_;
    my( $self ) = $class->SUPER::new(
        undef,
        -1,
        $params->{caption},
        wxDefaultPosition,
        [400,300],
             wxMAXIMIZE_BOX|
             wxMINIMIZE_BOX|
             wxRESIZE_BORDER|
             wxDEFAULT_DIALOG_STYLE|
             wxDIALOG_NO_PARENT|
             wxSTAY_ON_TOP
    );

    $self->SetBackgroundStyle(wxBG_STYLE_CUSTOM);

    Wx::InitAllImageHandlers();

    EVT_SIZE($self, sub {
            my ( $this, $event ) = @_;
    
            $this->Refresh;
            $event->Skip();
        }
    );


  EVT_PAINT(
      $self, 
      sub { 
          my ( $this, $event ) = @_;

          my $dc = Wx::AutoBufferedPaintDC->new($this);
          if($this->image){
      
              my ($w, $h) = $this->GetSizeWH;
              my $p_prop = $w / $h;
      
              # calculation made to keep aspect           
              # ratio and maximize image size
      
              my $scale;
              my ($img_w, $img_h) = @{$this->image_size};
              return unless $img_w;
              return unless $img_h;

              my $img_prop = $img_w / $img_h;
      
              $scale = ($p_prop > $img_prop)
              ? ($h / $img_h)
              : ($w / $img_w);
      
              $scale = 1 if($scale > 1);
      
              my ($sw, $sh) = map({$_ * $scale} $img_w, $img_h);
              my $bmp = Wx::Bitmap->new($this->image->Scale($sw, $sh, wxIMAGE_QUALITY_HIGH));
              my $xoff = ($w - $sw) / 2;
              my $yoff = ($h - $sh) / 2;
              $dc->DrawBitmap($bmp, $xoff, $yoff, $dc->Clear ? 1:1);
          }
          else{
              $dc->Clear;
          }
      }
  );

  
  $self;
}


1;
