# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApiVersionSetEntityBase(Model):
    """Api Version set base parameters.

    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API
     Version if versioningScheme is set to `query`.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates
     the API Version if versioningScheme is set to `header`.
    :type version_header_name: str
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApiVersionSetEntityBase, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.version_query_name = kwargs.get('version_query_name', None)
        self.version_header_name = kwargs.get('version_header_name', None)
