# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationStorageClassificationMappingsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_storage_classification_mappings_list_by_replication_storage_classifications(
        self, resource_group
    ):
        response = self.client.replication_storage_classification_mappings.list_by_replication_storage_classifications(
            fabric_name="str",
            storage_classification_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_storage_classification_mappings_get(self, resource_group):
        response = self.client.replication_storage_classification_mappings.get(
            fabric_name="str",
            storage_classification_name="str",
            storage_classification_mapping_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_storage_classification_mappings_begin_create(self, resource_group):
        response = self.client.replication_storage_classification_mappings.begin_create(
            fabric_name="str",
            storage_classification_name="str",
            storage_classification_mapping_name="str",
            pairing_input={"properties": {"targetStorageClassificationId": "str"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_storage_classification_mappings_begin_delete(self, resource_group):
        response = self.client.replication_storage_classification_mappings.begin_delete(
            fabric_name="str",
            storage_classification_name="str",
            storage_classification_mapping_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_storage_classification_mappings_list(self, resource_group):
        response = self.client.replication_storage_classification_mappings.list(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
