# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.loganalytics import LogAnalyticsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestLogAnalyticsManagementDataSourcesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(LogAnalyticsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_sources_create_or_update(self, resource_group):
        response = self.client.data_sources.create_or_update(
            resource_group_name=resource_group.name,
            workspace_name="str",
            data_source_name="str",
            parameters={
                "kind": "str",
                "properties": {},
                "etag": "str",
                "id": "str",
                "name": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_sources_delete(self, resource_group):
        response = self.client.data_sources.delete(
            resource_group_name=resource_group.name,
            workspace_name="str",
            data_source_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_sources_get(self, resource_group):
        response = self.client.data_sources.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            data_source_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_data_sources_list_by_workspace(self, resource_group):
        response = self.client.data_sources.list_by_workspace(
            resource_group_name=resource_group.name,
            workspace_name="str",
            filter="str",
            api_version="2025-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
