\name{utilities}

\alias{utilities}
\alias{writeDynLib}
\alias{readDynLib}
\alias{print,CFunc-method}
\alias{print,CFuncList-method}
\alias{code}
\alias{code-methods}
\alias{code,character-method}
\alias{code,CFunc-method}
\alias{code,CFuncList-method}

\title{ printing, reading and writing CFunc objects }

\description{
  \code{writeDynLib} saves the DLL and the CFunc or CFuncList object as
   generated by \link{cfunction}; \code{readDynLib} loads it.
   
  The \code{print} and \code{code} methods respectively print the entire 
  object or the code parts.
}

\usage{
  writeDynLib(x, file)
  readDynLib(file)
}

\section{Methods}{

\itemize{
 \item Method \code{print(x, ...)} prints the entire object \code{x}

  \describe{

    \item{\code{signature(x = "CFunc")}}{Prints the CFunc object 
generated by \code{\link{cfunction}}, including the code that generated it. }

    \item{\code{signature(x = "CFuncList")}}{Print all CFunc objects
generated by \code{\link{cfunction}}, including the code that generated them. }

  }

 \item Method \code{code(x, linenumbers = TRUE, ...)} prints the code only

  \describe{

    \item{\code{signature(x)}}{The \code{CFunc} or \code{CFuncList} object as generated by 
\code{\link{cfunction}}. }

    \item{\code{linenumbers}}{If \code{TRUE} all code lines will be numbered. }

  }
}
}

\arguments{

  \item{x}{A \code{CFunc} or \code{CFuncList} object as created by \code{\link{cfunction}} to be saved.}
    
  \item{file}{base name of the file to write the object to or to read from. 
    Two files will be saved, one for the shared object or DLL (extension \code{so}
    or \code{DLL}) and one that holds the \code{CFunc} or \code{CFuncList} specification, without
    the function address (extension \code{CFunc}).}

}

\value{
  Function \code{readDynLib} returns a \code{CFunc} or \code{CFuncList} object.
}

\details{
    
  Both the CFunc or CFuncList object and the shared object or DLL are saved,
  in two files; the first has extension \code{CFunc}; the second \code{so} or
  \code{DLL}, depending on the operating system used.
   
  When reading, both files are loaded, and the compiled function address 
  added to the object.
 
}

\note{

\itemize{
\item The code of a \code{CFunc} or \code{CFuncList} object \code{x} can be extracted 
(rather than printed), using: 

\code{x@code}. 
\item To write the code to a file (here called \code{"fn"}), 
without the new-line character \code{"\n"}:

\code{write (strsplit(x, "\n")[[1]], file = "fn")}
}

}

\seealso{ \code{
    \link{getDynLib} 
}}

\examples{

x <- as.numeric(1:10)
n <- as.integer(10)

code <- "
      integer i
      do 1 i=1, n(1)
    1 x(i) = x(i)**3
"
cubefn <- cfunction(signature(n="integer", x="numeric"), code, convention=".Fortran")
code(cubefn)

cubefn(n, x)$x

\dontrun{
 fname <- tempfile()
 writeDynLib(cubefn, file = fname)
 # load and assign different name to object
 cfn <- readDynLib(fname)
 print(cfn)
 cfn(2, 1:2)
}

}

\author{
  Karline Soetaert
}

\keyword{file}

