% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding_management.R
\name{stri_enc_mark}
\alias{stri_enc_mark}
\title{Get Declared Encodings of Each String}
\usage{
stri_enc_mark(str)
}
\arguments{
\item{str}{character vector
or an object coercible to a character vector}
}
\value{
Returns a character vector of the same length as \code{str}.
Unlike in the \code{\link{Encoding}} function, here the possible encodings are:
\code{ASCII}, \code{latin1}, \code{bytes}, \code{native},
and \code{UTF-8}. Additionally, missing values are handled properly.

This gives exactly the same data that is used by
all the functions in \pkg{stringi} to re-encode their inputs.
}
\description{
Reads declared encodings for each string in a character vector
as seen by \pkg{stringi}.
}
\details{
According to \code{\link{Encoding}},
\R has a simple encoding marking mechanism:
strings can be declared to be in \code{latin1},
\code{UTF-8} or \code{bytes}.

Moreover, we may check (via the R/C API) whether
a string is in ASCII (\R assumes that this holds if and only if
all bytes in a string are not greater than 127,
so there is an implicit assumption that your platform uses
an encoding that extends ASCII)
or in the system's default (a.k.a. \code{unknown} in \code{\link{Encoding}})
encoding.

Intuitively, the default encoding should be equivalent to
the one you use on stdin (e.g., your "keyboard").
In \code{stringi} we assume that such an encoding
is equivalent to the one returned by \code{\link{stri_enc_get}}.
It is automatically detected by \pkg{ICU}
to match -- by default -- the encoding part of the \code{LC_CTYPE} category
as given by \code{\link{Sys.getlocale}}.
}
\seealso{
Other encoding_management: 
\code{\link{stri_enc_info}()},
\code{\link{stri_enc_list}()},
\code{\link{stri_enc_set}()},
\code{\link{stringi-encoding}}
}
\concept{encoding_management}
