% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{wkb_meta}
\alias{wkb_meta}
\alias{wkt_meta}
\alias{wkt_streamer_meta}
\alias{wk_geometry_type}
\alias{wk_geometry_type_id}
\title{Extract meta information}
\usage{
wkb_meta(wkb, recursive = FALSE)

wkt_meta(wkt, recursive = FALSE)

wkt_streamer_meta(wkt, recursive = FALSE)

wk_geometry_type(type_id)

wk_geometry_type_id(type)
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{sf::st_as_binary()}.}

\item{recursive}{Pass \code{TRUE} to recurse into multi-geometries
and collections to extract meta of sub-geometries}

\item{wkt}{A character vector containing well-known text.}

\item{type_id}{An integer version of the geometry type}

\item{type}{A string version of the geometry type (e.g.,
point, linestring, polygon, multipoint, multilinestring,
multipolygon, geometrycollection)}
}
\value{
A data.frame with columns:
\itemize{
\item \code{feature_id}: The index of the top-level feature
\item \code{nest_id}: The recursion level (if feature is a geometry collection)
\item \code{part_id}: The part index (if nested within a multi-geometry or collection)
\item \code{type_id}: The type identifier (see \code{\link[=wk_geometry_type]{wk_geometry_type()}})
\item \code{size}: For points and linestrings the number of points, for polygons
the number of rings, and for mutlti-geometries and collection types,
the number of child geometries.
\item \code{srid}: The spatial reference identifier as an integer
}
}
\description{
Extract meta information
}
\examples{
wkt_meta("POINT (30 10)")
wkt_meta("GEOMETRYCOLLECTION (POINT (30 10))", recursive = FALSE)
wkt_meta("GEOMETRYCOLLECTION (POINT (30 10))", recursive = TRUE)

}
