/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Leg {
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// Leg duration in seconds  If leg is footpath:   The footpath duration is derived from the default footpath   duration using the query parameters `transferTimeFactor` and   `additionalTransferTime` as follows:   `leg.duration = defaultDuration * transferTimeFactor + additionalTransferTime.`   In case the defaultDuration is needed, it can be calculated by   `defaultDuration = (leg.duration - additionalTransferTime) / transferTimeFactor`.   Note that the default values are `transferTimeFactor = 1` and   `additionalTransferTime = 0` in case they are not explicitly   provided in the query. 
    #[serde(rename = "duration")]
    pub duration: i32,
    /// leg departure time
    #[serde(rename = "startTime")]
    pub start_time: String,
    /// leg arrival time
    #[serde(rename = "endTime")]
    pub end_time: String,
    /// scheduled leg departure time
    #[serde(rename = "scheduledStartTime")]
    pub scheduled_start_time: String,
    /// scheduled leg arrival time
    #[serde(rename = "scheduledEndTime")]
    pub scheduled_end_time: String,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// Whether this leg was originally scheduled to run or is an additional service. Scheduled times will equal realtime times in this case. 
    #[serde(rename = "scheduled")]
    pub scheduled: bool,
    /// For non-transit legs the distance traveled while traversing this leg in meters.
    #[serde(rename = "distance", skip_serializing_if = "Option::is_none")]
    pub distance: Option<f64>,
    /// For transit legs, if the rider should stay on the vehicle as it changes route names.
    #[serde(rename = "interlineWithPreviousLeg", skip_serializing_if = "Option::is_none")]
    pub interline_with_previous_leg: Option<bool>,
    /// For transit legs, the headsign of the bus or train being used. For non-transit legs, null 
    #[serde(rename = "headsign", skip_serializing_if = "Option::is_none")]
    pub headsign: Option<String>,
    /// final stop of this trip (can differ from headsign)
    #[serde(rename = "tripTo", skip_serializing_if = "Option::is_none")]
    pub trip_to: Option<Box<models::Place>>,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    #[serde(rename = "routeTextColor", skip_serializing_if = "Option::is_none")]
    pub route_text_color: Option<String>,
    #[serde(rename = "routeType", skip_serializing_if = "Option::is_none")]
    pub route_type: Option<i32>,
    #[serde(rename = "agencyName", skip_serializing_if = "Option::is_none")]
    pub agency_name: Option<String>,
    #[serde(rename = "agencyUrl", skip_serializing_if = "Option::is_none")]
    pub agency_url: Option<String>,
    #[serde(rename = "agencyId", skip_serializing_if = "Option::is_none")]
    pub agency_id: Option<String>,
    #[serde(rename = "tripId", skip_serializing_if = "Option::is_none")]
    pub trip_id: Option<String>,
    #[serde(rename = "routeShortName", skip_serializing_if = "Option::is_none")]
    pub route_short_name: Option<String>,
    #[serde(rename = "routeLongName", skip_serializing_if = "Option::is_none")]
    pub route_long_name: Option<String>,
    #[serde(rename = "tripShortName", skip_serializing_if = "Option::is_none")]
    pub trip_short_name: Option<String>,
    #[serde(rename = "displayName", skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// Whether this trip is cancelled
    #[serde(rename = "cancelled", skip_serializing_if = "Option::is_none")]
    pub cancelled: Option<bool>,
    /// Filename and line number where this trip is from
    #[serde(rename = "source", skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    /// For transit legs, intermediate stops between the Place where the leg originates and the Place where the leg ends. For non-transit legs, null. 
    #[serde(rename = "intermediateStops", skip_serializing_if = "Option::is_none")]
    pub intermediate_stops: Option<Vec<models::Place>>,
    #[serde(rename = "legGeometry")]
    pub leg_geometry: Box<models::EncodedPolyline>,
    /// A series of turn by turn instructions used for walking, biking and driving. 
    #[serde(rename = "steps", skip_serializing_if = "Option::is_none")]
    pub steps: Option<Vec<models::StepInstruction>>,
    #[serde(rename = "rental", skip_serializing_if = "Option::is_none")]
    pub rental: Option<Box<models::Rental>>,
    /// Index into `Itinerary.fareTransfers` array to identify which fare transfer this leg belongs to 
    #[serde(rename = "fareTransferIndex", skip_serializing_if = "Option::is_none")]
    pub fare_transfer_index: Option<i32>,
    /// Index into the `Itinerary.fareTransfers[fareTransferIndex].effectiveFareLegProducts` array to identify which effective fare leg this itinerary leg belongs to 
    #[serde(rename = "effectiveFareLegIndex", skip_serializing_if = "Option::is_none")]
    pub effective_fare_leg_index: Option<i32>,
    /// Alerts for this stop.
    #[serde(rename = "alerts", skip_serializing_if = "Option::is_none")]
    pub alerts: Option<Vec<models::Alert>>,
    /// If set, this attribute indicates that this trip has been expanded beyond the feed end date (enabled by config flag `timetable.dataset.extend_calendar`) by looping active weekdays, e.g. from calendar.txt in GTFS. 
    #[serde(rename = "loopedCalendarSince", skip_serializing_if = "Option::is_none")]
    pub looped_calendar_since: Option<String>,
}

impl Leg {
    pub fn new(mode: models::Mode, from: models::Place, to: models::Place, duration: i32, start_time: String, end_time: String, scheduled_start_time: String, scheduled_end_time: String, real_time: bool, scheduled: bool, leg_geometry: models::EncodedPolyline) -> Leg {
        Leg {
            mode,
            from: Box::new(from),
            to: Box::new(to),
            duration,
            start_time,
            end_time,
            scheduled_start_time,
            scheduled_end_time,
            real_time,
            scheduled,
            distance: None,
            interline_with_previous_leg: None,
            headsign: None,
            trip_to: None,
            route_color: None,
            route_text_color: None,
            route_type: None,
            agency_name: None,
            agency_url: None,
            agency_id: None,
            trip_id: None,
            route_short_name: None,
            route_long_name: None,
            trip_short_name: None,
            display_name: None,
            cancelled: None,
            source: None,
            intermediate_stops: None,
            leg_geometry: Box::new(leg_geometry),
            steps: None,
            rental: None,
            fare_transfer_index: None,
            effective_fare_leg_index: None,
            alerts: None,
            looped_calendar_since: None,
        }
    }
}

