/* parport.h - Parallel port I/O functions
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

enum
{ PP_DATA, PP_STATUS, PP_CONTROL };

extern int sane_geniusvp2_parport_open (const char *pp_device);
extern int sane_geniusvp2_parport_close (void);
extern int sane_geniusvp2_epp_read (unsigned char *data, int size);
extern int sane_geniusvp2_epp_write (unsigned char *data, int size);
#ifdef __linux__
extern int sane_geniusvp2_epp_set_mode (int mode);
#elif defined (__FreeBSD__) || defined(__FreeBSD_kernel__)
extern int sane_geniusvp2_epp_write_addr (unsigned char addr);
#endif
extern int sane_geniusvp2_pp_read (unsigned long int line, unsigned char *data);
extern int sane_geniusvp2_pp_write (unsigned long int line, unsigned char data);
