/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.events.AAxisAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;

public class AxisActionSetFormatter
extends AAxisAction {
    private IAxisLabelFormatter m_formatter;

    public IAxisLabelFormatter getFormatter() {
        return this.m_formatter;
    }

    public AxisActionSetFormatter(Chart2D chart, String description, int axis, IAxisLabelFormatter formatter) {
        super(chart, description, axis);
        this.m_formatter = formatter;
        if (axis == 1) {
            chart.getAxisX().addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
            chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X", this);
        } else if (axis == 2) {
            chart.getAxisY().addPropertyChangeListener("IAxis.PROPERTY_LABELFORMATTER", this);
            chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y", this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton item = (AbstractButton)e.getSource();
        boolean state = item.isSelected();
        if (state) {
            this.getAxis().setFormatter(this.m_formatter);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String property = evt.getPropertyName();
        if (property.equals("IAxis.PROPERTY_LABELFORMATTER")) {
            if (this.m_formatter.equals(evt.getOldValue())) {
                if (!this.m_formatter.equals(evt.getNewValue())) {
                    this.firePropertyChange("", Boolean.TRUE, Boolean.FALSE);
                }
            } else if (this.m_formatter.equals(evt.getNewValue())) {
                this.firePropertyChange("", Boolean.FALSE, Boolean.TRUE);
            }
        }
    }
}

