// ==UserScript==
// @include       http://*.mail.ru/*
// @include       http://mail.ru/
// @require       utils.js
// ==/UserScript==

// This placeholder gets munged with real data at build time.
var WebappsGettextDict = JSON.parse(unescape(
    "%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D"
));

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['g_mail_events'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var countElement = document.getElementById('g_mail_events');
    function checkMessagesCount() {
        var count = countElement.textContent;

        Unity.MessagingIndicator.showIndicator(_("Inbox"), { count: count });
    }

    countElement.addEventListener('DOMSubtreeModified', wrapCallback(checkMessagesCount), false);

    checkMessagesCount();
}

if (isCorrectPage()) {
    Unity.init({ name: _("mail.ru"),
                 domain: 'mail.ru',
                 homepage: 'http://mail.ru/',
                 iconUrl: "icon://unity-webapps-mail-ru",
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
