/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif 
#else
 #include <gnome.h>
#endif
#include <string.h>
#include <vdkb2/vdkb_cbrowse.h>
#include <vdkb2/vdkb_types.h>
#include <ctype.h>
#include <unistd.h>
#include "pixmaps/stop.xpm"
#include "pixmaps/stock_button_ok.xpm"

static char buff[128];

/*
main form constructor
*/
VDKBColorBrowser::VDKBColorBrowser(VDKForm* owner,VDKDefaultColor* color, char* title):
	VDKForm(owner,title), color (color)
{
  
}

/*
main form destructor
*/
VDKBColorBrowser::~VDKBColorBrowser()
{
}

/*
main form setup
*/
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(VDKBColorBrowser,VDKForm);
DEFINE_EVENT_LIST(VDKBColorBrowser,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(VDKBColorBrowser,VDKForm)
ON_SIGNAL(cancel,clicked_signal,OncancelClick),
ON_SIGNAL(accept,clicked_signal,OnacceptClick)
END_SIGNAL_MAP
/*
main form setup
*/
void
VDKBColorBrowser::GUISetup(void)
{
	SetSize(336,265);
	Title = _("VDKBuilder color browser");
	vbox = new VDKBox(this,v_box);
	Add(vbox,0,1,1,0);
	evbox = new VDKEventBox(this,v_box);
	evbox->SetSize(266,223);
	vbox->Add(evbox,0,1,1,0);
	evbox->BorderWidth(0);
	scrolled = new VDKScrolled(this);
	evbox->Add(scrolled,0,1,1,0);
	separator0 = new VDKSeparator(this,h_separator);
	vbox->Add(separator0,0,0,0,0);
	hbox4 = new VDKBox(this,h_box);
	hbox4->SetSize(334,30);
	vbox->Add(hbox4,0,0,0,0);
	hbox4->BorderWidth(0);
	label = new VDKLabel(this," ");
	hbox4->Add(label,0,1,1,0);
	accept = new VDKCustomButton(this, (const char**) stock_button_ok_xpm,_("_Accept"),16,(GtkPositionType) 1);
	hbox4->Add(accept,0,0,0,0);
	cancel = new VDKCustomButton(this,  (const char**) stop_xpm,_("_Cancel"),16,(GtkPositionType) 1);
	hbox4->Add(cancel,0,0,0,0);
}

void
VDKBColorBrowser::Setup(void)
{
  GUISetup();  
  selectedCanvas = -1;
  evbox->SetTip (_("Pick a color")); 
  int column = 16;
  int row = 0;
  int remind = 0;
  ReadRGB ();
  row = colorList.size ()/column;
  remind = (colorList.size())%column;
  row = remind ? row+1 : row;
  if (row)
    {
    int c, r, t = 0;
    VDKTable *table = 
        new VDKTable (this,row, column, true); 
    ColorListIterator li (colorList);
    canvasArray.resize (colorList.size ());
    for (r = 0; r < row; r++)
      for (c = 0; c < column; c++, t++, li++)
      {
        if (t < colorList.size ())
        {
        VDKDefaultColor color = li.current ();
        VDKRgb rgb (color.red, color.green, color.blue) ;
        canvasArray[t] = new VDKCanvas (this, 15, 15);
        canvasArray[t]->NormalBackground = rgb;
        table->AddToCell (canvasArray[t], r, c);
        EventConnect (canvasArray[t], "button_press_event", 
                    &VDKBColorBrowser::OnCanvasClick);
        }
      else
        break;
      }
     scrolled->Add (table);
    }  
}

bool
VDKBColorBrowser::OnCanvasClick (VDKObject* sender,  GdkEvent*)
{
  int t = 0;
  for (; t < canvasArray.size (); t++)
    if (sender ==  canvasArray[t])
      break;
  if (t < colorList.size ())
    {
    if (selectedCanvas >= 0)
      {
      canvasArray[selectedCanvas]->Clear ();
      canvasArray[selectedCanvas]->Redraw ();
    }
    selectedCanvas = t;  
    VDKRgb rgb = DefaultColorsColorRgb (t);
    sprintf (buff, "\"%s\"\nVDKRgb (%d,%d,%d)",
        DefaultColorsName (t),  rgb.red, rgb.green, rgb.blue);
    label->Caption = buff;
  }
  else
    selectedCanvas = -1;
  return true;
}

//signal response method
bool 
VDKBColorBrowser::OnacceptClick(VDKObject* sender) 
{
 if (selectedCanvas >=  0)
  *color = colorList[selectedCanvas];
  Close ();
 return true;
 }
 
//asks user before closing
void
VDKBColorBrowser::OnExpose(VDKForm* sender, GdkRectangle area)
{
  if (selectedCanvas >=  0)
  {
    GtkWidget* widget = canvasArray[selectedCanvas]->Widget ();
    int w = widget->allocation.width;
    int h = widget->allocation.height;
    canvasArray[selectedCanvas]->DrawRect (false, 0, 0, w-1, h-1);
    canvasArray[selectedCanvas]->Redraw ();
   }    
return;
}

//signal response method
bool 
VDKBColorBrowser::OncancelClick(VDKObject* sender) 
{
  Close ();
 return true;
 }

bool
VDKBColorBrowser::ReadRGB()
{
  int red,green,blue;
  char colorname[64];
  FILE* fp = NULL;
  sprintf(buff,"%s/res/%s",VDKB_DATADIR,VDKB_RGB);
  if(!access(buff,F_OK))
    fp = fopen(buff,"r");
  if(!fp)
    return false;
  colorList.flush();
  // jump first line 
  fgets(buff,sizeof(buff),fp);
  while(fgets(buff,sizeof(buff),fp))
    {
    char* p;
    buff[strlen(buff)-1] = '\0';
    sscanf(buff,"%d %d %d",&red,&green,&blue);
    // find first alpha
    for(p = buff; *p && (!isalpha(*p)); p++);
    if(*p)
      strcpy(colorname,p);
    else
      strcpy(colorname,"black");
    VDKDefaultColor color(colorname,red,green,blue);
    colorList.add(color);
    }
  fclose(fp);
  return true;
}
/*
*/
VDKRgb 
VDKBColorBrowser::DefaultColorsColorRgb (int t)
{
  VDKDefaultColor color = colorList[t];
  return VDKRgb (color.red, color.green, color.blue);
}
/*
*/
char*
VDKBColorBrowser::DefaultColorsName (int t)
{
    return (char*) colorList[t].name;
}

