/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.loading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.ContentLoader;

public class LoaderThreadPool {
    private static final String THREAD_COUNT_PROP = "org.xj3d.core.loading.threads";
    private static int DEFAULT_THREAD_COUNT;
    private ContentLoadQueue pending = new ContentLoadQueue();
    private HashMap inProgress = new HashMap();
    private ContentLoader[] loaders;
    private static LoaderThreadPool threadPool;
    private static ThreadGroup threadGroup;

    private LoaderThreadPool() {
        Integer n;
        int n2;
        if (threadGroup == null) {
            threadGroup = new ThreadGroup("Xj3D Content Loaders");
        }
        if ((n2 = (n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n = Runtime.getRuntime().availableProcessors();
                DEFAULT_THREAD_COUNT = n == 1 ? 1 : n - 1;
                return Integer.getInteger(LoaderThreadPool.THREAD_COUNT_PROP, DEFAULT_THREAD_COUNT);
            }
        })).intValue()) <= 0) {
            n2 = DEFAULT_THREAD_COUNT;
        }
        if (n2 != DEFAULT_THREAD_COUNT) {
            System.out.println("org.xj3d.core.loading.threads set to: " + n2);
        }
        this.loaders = new ContentLoader[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            this.loaders[n3] = new ContentLoader(threadGroup, this.pending, this.inProgress);
        }
    }

    public static LoaderThreadPool getLoaderThreadPool() {
        if (threadPool == null) {
            threadPool = new LoaderThreadPool();
        }
        return threadPool;
    }

    public static void setThreadGroup(ThreadGroup threadGroup) throws IllegalStateException {
        if (LoaderThreadPool.threadGroup != null) {
            throw new IllegalStateException("Cannot assign thread group now");
        }
        LoaderThreadPool.threadGroup = threadGroup;
    }

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i].setErrorReporter(errorReporter);
        }
    }

    public ContentLoadQueue getWaitingList() {
        return this.pending;
    }

    public Map getProgressMap() {
        return this.inProgress;
    }

    public void clear() {
        this.pending.purge();
        int n = this.loaders.length;
        while (--n >= 0) {
            this.loaders[n].abortCurrentFile();
        }
    }

    public synchronized void shutdown() {
        if (threadPool != null) {
            int n = this.loaders.length;
            while (--n >= 0) {
                this.loaders[n].shutdown();
                this.loaders[n] = null;
            }
            this.pending.purge();
        }
        threadPool = null;
    }

    public void restartThreads() {
        int n;
        int n2 = n = this.loaders.length;
        while (--n2 >= 0) {
            if (this.loaders[n2].isAlive()) continue;
            this.loaders[n2] = new ContentLoader(threadGroup, this.pending, this.inProgress);
        }
    }
}

