/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Debug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

final class Config {
    private HashMap map = new HashMap();
    private File file;
    private boolean modified = false;

    Config(String filename) {
        this.file = new File(filename);
    }

    public void load() {
        Debug.println("Loading configuration file...");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            while ((line = in.readLine()) != null) {
                String[] pair = this.getPair(line);
                if (pair == null || pair[0] == null || pair[0].length() == 0) continue;
                this.map.put(pair[0], pair[1]);
            }
        }
        catch (IOException in) {
        }
        catch (Exception e) {
            System.err.println("error parsing config file: " + e);
        }
        this.modified = false;
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        Debug.println("Saving configuration file...");
        String tmpfilename = this.file + ".tmp";
        File tmp = new File(tmpfilename);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tmp)));
            while ((line = in.readLine()) != null) {
                String[] pair = this.getPair(line.toUpperCase());
                if (pair != null && pair[0] != null && this.map.get(pair[0]) != null) {
                    out.println(pair[0] + '=' + this.map.get(pair[0]));
                    continue;
                }
                out.println(line);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.err.println("io error saving config file: " + e);
            return;
        }
        catch (Exception e) {
            System.err.println("error saving config file: " + e);
            return;
        }
        this.file.delete();
        tmp.renameTo(this.file);
        this.modified = false;
    }

    private String[] getPair(String line) {
        int index = line.indexOf(61);
        if (index < 0) {
            return null;
        }
        if (line.startsWith("#") || line.startsWith(";")) {
            return null;
        }
        String[] pair = new String[]{line.substring(0, index).trim(), line.substring(index + 1).trim()};
        return pair;
    }

    public String get(String key) {
        return (String)this.map.get(key);
    }

    public int getInt(String key) {
        String value = (String)this.map.get(key);
        if (value == null) {
            return -1;
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return intValue;
    }

    public boolean getBoolean(String key) {
        String value = (String)this.map.get(key);
        if (value == null) {
            return false;
        }
        return value.equals("TRUE");
    }

    public void set(String key, String value) {
        this.modified = true;
        this.map.put(key, value);
    }

    public void setInt(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public void setBoolean(String key, boolean value) {
        this.set(key, value ? "TRUE" : "FALSE");
    }
}

